#!/bin/bash
set -euo pipefail

#=============================================================================
# Script: 0-check-system.sh
# PURPOSE: Verify system readiness and content availability
#=============================================================================

echo "🔍 RKPi5 v2.1 System Check (Desktop paths)"

USER_FIXED="rk-pi5-user"
HOME_FIXED="/home/${USER_FIXED}"
CONTENT_DIR="${HOME_FIXED}/Desktop/rapture_kit"

MODEL=$(tr -d ' ' </sys/firmware/devicetree/base/model 2>/dev/null || echo Unknown)
MEM=$(free -h | awk '/^Mem:/{print $2}')
TEMP=$(vcgencmd measure_temp 2>/dev/null | cut -d= -f2 || echo N/A)

echo "🖥️ Model: ${MODEL}"
echo "💾 Memory: ${MEM}"
echo "🌡️ CPU Temp: ${TEMP}"

echo "
📁 Content Check: ${CONTENT_DIR}"
if [[ -f "${CONTENT_DIR}/index.html" ]]; then
echo "✅ Found index.html"
echo " Size: $(du -sh "${CONTENT_DIR}" | cut -f1) Files: $(find "${CONTENT_DIR}" -type f | wc -l)"
else
echo "❌ Missing ${CONTENT_DIR}/index.html — run setup-golden-master.sh first"; exit 1
fi

iwconfig wlan0 >/dev/null 2>&1 && echo "✅ wlan0 present" || { echo "❌ wlan0 missing"; exit 1; }

echo "
🌐 Internet check (for package install only):"
ping -c1 8.8.8.8 >/dev/null 2>&1 && echo "✅ Internet reachable" || echo "⚠️ No internet (core install may fail)"

echo "
✅ System check complete"
