#!/bin/bash
set -euo pipefail

#=============================================================================
# Script: 5-validate-deployment.sh
# PURPOSE: Comprehensive end-to-end validation
#=============================================================================

echo "✅ RKPi5 v2.1 Deployment Validation"

USER_FIXED="rk-pi5-user"
HOME_FIXED="/home/${USER_FIXED}"
CONTENT_DIR="${HOME_FIXED}/Desktop/rapture_kit"

if iwconfig wlan0 2>/dev/null | grep -q "Mode:Master"; then
echo "📡 Hotspot: ACTIVE (SSID: $(iwconfig wlan0 | awk -F'"' '/ESSID/{print $2}') )"
ip addr show wlan0 | awk '/inet 10.42.0.1/{print " IP:",$2}' || echo " IP: (pending)"
else
echo "❌ Not in hotspot mode. Run: nmcli connection up rapture_kit_hotspot"
fi

systemctl is-active --quiet nginx && echo "✅ nginx running" || echo "❌ nginx not running"
systemctl is-active --quiet NetworkManager && echo "✅ NetworkManager running" || echo "❌ NetworkManager not running"

if [[ -f "/etc/NetworkManager/dnsmasq.d/captive-portal.conf" ]] && [[ -f "/etc/NetworkManager/dnsmasq-shared.d/captive-portal.conf" ]]; then
echo "✅ DNS hijack files present"
else
echo "❌ DNS hijack files missing"
fi

curl -s -o /dev/null -w "%{http_code}
" http://10.42.0.1/health | grep -q '^200' && echo "✅ HTTP /health OK" || echo "❌ HTTP /health fail"
curl -k -s -o /dev/null -w "%{http_code}
" https://10.42.0.1/health | grep -q '^200' && echo "✅ HTTPS /health OK" || echo "❌ HTTPS /health fail"

if [[ -f "${CONTENT_DIR}/index.html" ]]; then
echo "✅ Content accessible at ${CONTENT_DIR}"
echo " Files: $(find "${CONTENT_DIR}" -type f | wc -l) Size: $(du -sh "${CONTENT_DIR}" | cut -f1)"
stat -c ' Owner: %U:%G Perms: %a' "${CONTENT_DIR}/index.html" || true
else
echo "❌ Content missing at ${CONTENT_DIR}/index.html"
fi

if [[ -f "/etc/ssl/RKPi5/certificate.crt" ]]; then
echo "🔒 SSL present (expires: $(openssl x509 -in /etc/ssl/RKPi5/certificate.crt -noout -enddate | cut -d= -f2))"
else
echo "❌ SSL certificate missing"
fi

echo "
📋 Access Info:"
echo " Landing Page: http://10.42.0.1/"
echo " Training Portal: https://rapturekit.com/rapture_kit/"
echo " Admin Dashboard: https://rapturekit.com/admin/"

echo "
🎯 Status:"
echo " • Auto‑hotspot on boot"
echo " • Offline training ready"
